% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FSR.R
\name{FSR}
\alias{FSR}
\title{Factor Score Regression approach}
\usage{
FSR(lavModel_Analysis, data, FSmethod = "SL", data_transformations = NULL)
}
\arguments{
\item{lavModel_Analysis}{the lavModel_Analysis object}

\item{data}{set to fit}

\item{FSmethod}{Method to be used to extract factor scores. Default to \code{"SL"} for the Skrondal and Laake approach that uses regression (\code{"regression"}) factor scores for the independendent variables and \code{"Bartlett"} factor scores for the dependent variables.}

\item{data_transformations}{Data transformations}
}
\value{
Returns a \code{data.frame} that includes parameter estimates estimated using FSR.
}
\description{
Factor Score Regression approach
}
\references{
\strong{Similar to:} Ng, J. C. K., & Chan, W. (2020). Latent moderation analysis: A factor score approach. \emph{Structural Equation Modeling: A Multidisciplinary Journal, 27}(4), 629–648. \doi{10.1080/10705511.2019.1664304}.

Skrondal, A., & Laake, P. (2001). Regression among factor scores. \emph{Psychometrika, 66}(4), 563-575. \doi{10.1007/BF02296196}
}
