% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/push.R
\name{pbi_push_dataset_schema}
\alias{pbi_push_dataset_schema}
\title{Push a dataset schema to Power BI}
\usage{
pbi_push_dataset_schema(schema, group_id, retention = c("none", "basicFIFO"))
}
\arguments{
\item{schema}{A push-dataset schema created by pbi_schema_create().}

\item{group_id}{The ID of the destination Power BI workspace.}

\item{retention}{The retention policy of the dataset. Default is "none".}
}
\value{
A dataset with tables will be created in the specified Power BI
  workspace.
}
\description{
Pushes a dataset schema to the specified Power BI workspace. To add rows to
the dataset, use pbi_push_rows().
}
\examples{

\dontrun{

group_id <- "xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx"

schema <- pbi_schema_create(
  dt_list = list(iris),
  dataset_name = "The iris dataset",
  table_name_list = list(iris)
)

pbi_push_dataset_schema(schema, group_id)
}
}
