% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting-precision.R
\name{plot_precision_assurance_curve}
\alias{plot_precision_assurance_curve}
\title{Plot Precision Assurance Curve (Multi-Effect Grid Friendly)}
\usage{
plot_precision_assurance_curve(
  power_results,
  precision_target,
  x_effect = NULL,
  facet_by = NULL,
  effect_filters = NULL,
  effect_weights = NULL,
  title = NULL,
  subtitle = NULL
)
}
\arguments{
\item{power_results}{List returned by \verb{brms_inla_power*}.}

\item{precision_target}{Numeric; credible interval width threshold for success.}

\item{x_effect}{Name of effect grid column for x-axis (default: first grid column).}

\item{facet_by}{Optional effect grid column(s) for faceting.}

\item{effect_filters}{Optional named list for filtering rows, e.g. list(treatment=0).}

\item{effect_weights}{Optional named numeric vector for weights over selected x_effect values.}

\item{title, subtitle}{Optional plot labels.}
}
\value{
A ggplot object.
}
\description{
Plots the assurance (proportion of runs meeting CI width <= target) vs. a chosen effect grid variable across sample size(s).
Supports faceting, effect filtering, and weights.
}
