% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coalesce.R
\name{paste_xy}
\alias{paste_xy}
\alias{paste_yx}
\title{Paste helpers}
\usage{
paste_xy(x, y, sep = " ", na = NULL, ignore_empty = TRUE)

paste_yx(x, y, sep = " ", na = NULL, ignore_empty = TRUE)
}
\arguments{
\item{x}{A vector}

\item{y}{A vector}

\item{sep}{separator}

\item{na}{How to treat \code{NAs}, they are ignored by default, if \code{NA} the result
will be \code{NA}, just as with \code{stringr::str_c}, if \code{"NA"} NAs will be coerced
to character just as with \code{paste()}. Any other string can be used}

\item{ignore_empty}{Whether to ignore empty strings, to avoid trailing and leading separators}
}
\value{
A character vector
}
\description{
These are similar to \code{paste()} but by default ignore \code{NA} and empty strings
(\code{""}). If they are found in a conflicting column we return the value from
the other column without using the separator. If both columns have such values
we return an empty string.
}
\examples{
paste_xy(letters[1:3], c("d", NA, ""))
paste_yx(letters[1:3], c("d", NA, ""))
paste_xy(letters[1:3], c("d", NA, ""), na = NA, ignore_empty = FALSE)
paste_xy(letters[1:3], c("d", NA, ""), na = "NA", ignore_empty = FALSE)
}
