% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAnimatedPPGMMultiPhylo.R
\name{plotAnimatedPPGMMultiPhylo}
\alias{plotAnimatedPPGMMultiPhylo}
\title{plotAnimatedPPGMMultiPhylo}
\usage{
plotAnimatedPPGMMultiPhylo(envelope, tree, filename="ppgm.gif", 
which.biovars, path="", use.paleoclimate=TRUE, 
paleoclimateUser=NULL, layerAge=c(0:20), ...)
}
\arguments{
\item{envelope}{the min and max envelope of each lineage for each time slice}

\item{tree}{the phylogeny or multiple phylogenies that show the relationship between species}

\item{filename}{filename of output}

\item{which.biovars}{A vector of the numbers of the bioclimate variables that should be returned. The bioclimate variables number correspond to the Hijmans table at (https://www.worldclim.org/data/bioclim.html).}

\item{path}{path to the directory where the results should be saved}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19. (see \code{getBioclimvars()}).}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}

\item{...}{other parameters to pass to save_gif}
}
\value{
An animated gif of species through time
}
\description{
This function creates an animated gif showing the change in modeled suitable habitat through time in geographic space. It requires ImageMagick or GraphicsMagick to be previously installed in the operating system. This is easy to do if you have macports. Just type sudo port install ImageMagick into terminal.
}
\details{
Requires ImageMagick or GraphicsMagick to be installed on the operating system. This is easy to do if you have macports. Just type sudo port install ImageMagick into terminal.
}
\examples{
data(sampletrees)
data(occurrences)
sampletrees <- sample(sampletrees,5)
biooccu <- getBioclimVars(occurrences, which.biovars=1)
sp_data_min<- tapply(biooccu[,4],biooccu$Species,min)
sp_data_max<- tapply(biooccu[,4],biooccu$Species,max)
treedata_min <- treedata_max <- node_est <- envelope <- list()
\dontrun{for (tr in 1:length(sampletrees)){
  treedata_min[[tr]] <- geiger::treedata(sampletrees[[tr]],sp_data_min,sort=TRUE,warnings=F)
  treedata_max[[tr]] <- geiger::treedata(sampletrees[[tr]],sp_data_max,sort=TRUE,warnings=F)
  full_est <- nodeEstimateEnvelopes(treedata_min[[tr]],treedata_max[[tr]])
  node_est[[tr]] <- full_est$est
  envelope[[tr]] <- getEnvelopes(treedata_min[[tr]], treedata_max[[tr]], node_est[[tr]])
}
animatedplot <- plotAnimatedPPGMMultiPhylo(envelope,sampletrees,which.biovars=1, path=tempdir())}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard
}
