% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/00_benin.R
\docType{data}
\name{ppiBEN2022_11q}
\alias{ppiBEN2022_11q}
\title{Poverty Probability Index (PPI) lookup table for Benin for 2022 for 11
questions score card}
\format{
A data frame with 14 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp320}}{Below $3.20 per day purchasing power parity (2011)}
\item{\code{ppp550}}{Below $5.50 per day purchasing power parity (2011)}
\item{\code{ppp215}}{Below $2.15 per day purchasing power parity (2017)}
\item{\code{ppp365}}{Below $3.65 per day purchasing power parity (2017)}
\item{\code{ppp685}}{Below $6.85 per day purchasing power parity (2017)}
\item{\code{percentile20}}{Below 20th percentile poverty line}
\item{\code{percentile40}}{Below 40th percentile poverty line}
\item{\code{percentile60}}{Below 60th percentile poverty line}
\item{\code{percentile80}}{Below 80th percentile poverty line}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiBEN2022_11q
}
\description{
Poverty Probability Index (PPI) lookup table for Benin for 2022 for 11
questions score card
}
\examples{
  # Access Benin PPI table
  ppiBEN2022_11q

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiBEN2022_11q[ppiBEN2022_11q$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiBEN2022_11q, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiBEN2022_11q[ppiBEN2022_11q$score == ppiScore, "nl100"]

}
\keyword{datasets}
