\name{pplot.pvals}
\alias{pplot.pvals}
\title{Generate p-plot from a series of p-values}
\description{Takes a series of p-values and plots them against the corresponding number of observations included in a test. Adds reference lines at the chosen alpha level (horizontal line) and at the latest point in time the p-plot crosses the significance threshold (if any).}
\usage{
pplot.pvals(xs,
            ps,
            xtitle = "Observation",
            alpha = 0.05,
            n.sig = TRUE,
            ylim.p = c(0,1),
            pcol.alpha = 125)
}

\arguments{
  \item{xs}{Vector of observations that the p values are computed on.}
  \item{ps}{vector of p-values.}
  \item{xtitle}{Axis title for the x-axis of the p-plot.}
  \item{alpha}{Significance threshold to be used for determining oversampling.}
  \item{n.sig}{Logical: Show vertical line at last crossing of the significance threshold?}
  \item{ylim.p}{Plot limits on the y-axis.}
  \item{pcol.alpha}{Transparency of the data points; set to 255 for solid fill.}
}
\details{
\code{pplot.pvals} generates a p-plot from two vectors: \code{xs} containing the sample sizes underlying the test results, and \code{ps} as the resulting p-values.
}
\value{
  \code{pplot.pvals()} returns a single integer with the number of oversampled datasets (-1 for a non-significant test at the full sample size).
}
% \references{}
\author{Roland Pfister}
% \note{}

\seealso{
  \code{\link{pplot.t.test}};
}
\examples{
# Show p-plot for significant test (the simulation 
# has a power of > 88% to return a significant 
# effect).
testdata <- rnorm(64, mean = 0.4, sd = 1)
ps <- matrix(data = NA, nrow = 60, ncol = 1)
for (itest in c(2:64)) {
  ps[itest] <- t.test(testdata[1:itest])$p.value
}
xs <- c(1:64)
pplot.pvals(xs,ps)

# Show p-plot for non-significant test (simulation 
# does not include a true effect).
testdata <- rnorm(64, mean = 0.0, sd = 1)
ps <- matrix(data = NA, nrow = 60, ncol = 1)
for (itest in c(2:64)) {
  ps[itest] <- t.test(testdata[1:itest])$p.value
}
xs <- c(1:64)
pplot.pvals(xs,ps)

}
\keyword{utilities}
