% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.mypls.R
\name{vcov.mypls}
\alias{vcov.mypls}
\title{Variance-Covariance Matrix for Penalized PLS Coefficients}
\usage{
\method{vcov}{mypls}(object, ...)
}
\arguments{
\item{object}{An object of class \code{"mypls"}, typically returned by \code{\link{jack.ppls}}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A numeric matrix representing the variance-covariance matrix of the regression coefficients, or \code{NULL} if unavailable.
}
\description{
Returns the estimated variance-covariance matrix of the regression coefficients from a jackknife-based PPLS model.
}
\details{
The function retrieves the covariance matrix stored in the \code{object$covariance} field. If this field is \code{NULL}, a warning is issued and the function returns \code{NULL}.

This method can be used in conjunction with \code{\link{coef.mypls}} and \code{\link{ttest.ppls}} to conduct inference on the coefficients of a penalized PLS model.
}
\examples{
set.seed(42)
X <- matrix(rnorm(30 * 100), ncol = 30)
y <- rnorm(100)

ppls.cv <- penalized.pls.cv(X, y, lambda = c(1, 10), ncomp = 3)
myjack <- jack.ppls(ppls.cv)
Sigma <- vcov(myjack)
Sigma[1:5, 1:5]

}
\seealso{
\code{\link{coef.mypls}}, \code{\link{jack.ppls}}, \code{\link{ttest.ppls}}
}
