% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeInfoForTable1.R
\name{computeInfoForTable1}
\alias{computeInfoForTable1}
\title{Computation of summary-level information needed for the creation of a "Table 1" of baseline patient characteristics}
\usage{
computeInfoForTable1(data, indA, indX, truncP = 1)
}
\arguments{
\item{data}{An individual-level dataset in the form of R data frame.}

\item{indA}{A column name indicating the exposure/treatment variable.}

\item{indX}{A vector of column names indicating the baseline covariates to be included in the propensity score model.}

\item{truncP}{A value between 0 and 1 indicating the percentile used for weight truncation. The default is 1, corresponding to no weight truncation.}
}
\value{
A data frame of summary-level information needed for the creation of a "Table 1" of baseline patient characteristics. Each covariate has a row of 19 numbers: covariate type ("yes" if it is binary, "no" if it is continuous/count), number of exposed individuals (same across rows), covariate mean of exposed individuals, covariate mean square of exposed individuals, total conventional weights of exposed individuals, weighted covariate mean of exposed individuals with conventional weights, weighted covariate mean square of exposed individuals with conventional weights, total stabilized weights of exposed individuals, weighted covariate mean of exposed individuals with stabilized weights, weighted covariate mean square of exposed individuals with stabilized weights, number of unexposed individuals (same across rows), covariate mean of unexposed individuals, covariate mean square of unexposed individuals, total conventional weights of unexposed individuals, weighted covariate mean of unexposed individuals with conventional weights, weighted covariate mean square of unexposed individuals with conventional weights, total stabilized weights of unexposed individuals, weighted covariate mean of unexposed individuals with stabilized weights, and weighted covariate mean square of unexposed individuals with stabilized weights.
}
\description{
Computation of summary-level information needed for the creation of a "Table 1" that shows the baseline patient characteristics in the original unweighted and the inverse probability weighted samples. A logistic regression model is used to estimate propensity scores with an option to do weight truncation. This is a function for data-contributing sites.
}
\examples{
#load an example dataset site1.RData in the package
#site1 contains individual-level data of data-contributing site 1
data(site1)
#site 1 computes summary-level information needed for creating the "Table 1"
#with logistic propensity score model A~X1+X2+X3+X4+X5
#no weight truncation
computeInfoForTable1(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=1)
#with truncation: set weights larger than the 90\% quantile of original weights to the 90\% quantile
computeInfoForTable1(data=site1,indA="A",indX=c("X1","X2","X3","X4","X5"),truncP=0.9)

}
