% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{visualize_both}
\alias{visualize_both}
\title{Visualize the PPS & correlation matrices}
\usage{
visualize_both(
  df,
  color_value_positive = "#08306B",
  color_value_negative = "#8b0000",
  color_text = "#FFFFFF",
  include_missings = TRUE,
  nrow = 1,
  ...
)
}
\arguments{
\item{df}{data.frame containing columns for x and y}

\item{color_value_positive}{color used for upper limit of gradient (high positive correlation)}

\item{color_value_negative}{color used for lower limit of gradient (high negative correlation)}

\item{color_text}{string, hex value or color name used for text, best to pick high contrast with \code{color_value_high}}

\item{include_missings}{bool, whether to include the variables without correlation values in the plot}

\item{nrow}{numeric, number of rows, either 1 or 2}

\item{...}{any arguments passed to \code{\link{score}}}
}
\value{
a grob object, a grid with two ggplot2 heatmap visualizations
}
\description{
Visualize the PPS & correlation matrices
}
\examples{
\donttest{visualize_both(iris)}

\donttest{visualize_both(mtcars, do_parallel = TRUE, n_cores = 2)}
}
