% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qTarald.R
\name{qTarald}
\alias{qTarald}
\title{Compute the quantile for exact t test density using Taraldsen's methods}
\usage{
qTarald(n, rho = 0, cum)
}
\arguments{
\item{n}{{number of observastions, n-1 is degrees of freedom}}

\item{rho}{{True unknown population correlation coefficient, default=0}}

\item{cum}{{cumulative probability for which quantile is needed}}
}
\value{
r quantile of Taraldsen's density for
correlation coefficient.
}
\description{
Compute the quantile for exact t test density using Taraldsen's methods
}
\note{
needs function hypergeo::hypergeo(). The quantiles are
rounded to 3 places and computed by numerical methods.
}
\references{
Taraldsen, G. "The Confidence Density for Correlation"
Sankhya: The Indian Journal of Statistics
2023, Volume 85-A, Part 1, pp. 600-616.
}
\seealso{
See Also as \code{\link{pvTarald}},
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
