% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crodesign.R
\name{crodesign}
\alias{crodesign}
\title{Generate Mating Design}
\usage{
crodesign(d, male_name, female_name, seed = 123)
}
\arguments{
\item{d}{an integer denoting 1/d percentage of crosses to be evaluated in the field.}

\item{male_name}{a character string for the names of male parents.}

\item{female_name}{a character string for the names of male parents.}

\item{seed}{the random number, default is 123.}
}
\value{
A data frame of mating design result with three columns. The first column is "crossID", the second column is the "male_Name" and the third column is the "female_Name".
}
\description{
Generate a mating design for a subset of crosses based on a balanced random partial rectangle cross-design (BRPRCD) (Xu et al. 2016).
}
\examples{

## generate a mating design with 100 male parents and 150 female parents
## for 1/d = 1/50 percentage of crosses to be evaluated in the field.
## the total number of potential crosses is 100*150 = 15000.
## The number of crosses to be field evaluated is 15000*(1/50) = 300.

male_name <- paste("m", 1:100, sep = "")
female_name <- paste("f", 1:150, sep = "")
design <- crodesign(d = 50, male_name, female_name)

}
\references{
Xu S, Xu Y, Gong L and Zhang Q. (2016) Metabolomic prediction of yield in hybrid rice. Plant J. 88, 219-227.
}
