% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modl.R
\name{modl.dataMining}
\alias{modl.dataMining}
\title{Train the data}
\usage{
modl.dataMining(form, tserieDF, algorithm, timeControl, metric = "RMSE",
  maximize = FALSE)
}
\arguments{
\item{form}{A formula of the form y ~ x1 + x2 + ...}

\item{tserieDF}{Data frame.}

\item{algorithm}{A string. Algorithm to perform the training. Full list at \url{http://topepo.github.io/caret/train-models-by-tag.html}. Only regression types allowed.}

\item{timeControl}{trainControl object.}

\item{metric}{A string. Specifies what summary metric will be used to select the optimal model. Possible values in \code{caret} are "RMSE" and "Rsquared". "RMSE" set as default. If you used a custom summaryFunction(see ?trainControl) your metrics will prevail over default.}

\item{maximize}{A logical. Should the metric be maximized or minimized? Default is FALSE, since that is what makes sense for time series.}
}
\value{
train object
}
\description{
Train the time serie(as data frame) to build the model.
}
\examples{
\donttest{
modl.dataMining(form=Class ~ .,
 tserieDF=modl.tsToDataFrame(AirPassengers,formula=c(1:20)),
 algorithm='rpart',
 timeControl=modl.trControl(initialWindow=30,horizon=15,fixedWindow=TRUE))
}
}
\author{
Alberto Vico Moreno
}
