% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_spec_to_html.R
\name{prereg_spec_to_html}
\alias{prereg_spec_to_html}
\title{Convert a (pre)registration specification to html}
\usage{
prereg_spec_to_html(
  x,
  file = NULL,
  section = NULL,
  headingLevel = 1,
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{file}{Optionally, a file to save the html to.}

\item{section}{Optionally, one or multiple sections to include (if \code{NULL},
all sections are included).}

\item{headingLevel}{The level of the top-most headings.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
The produced HTML, which will print in the viewer in RStudio.
}
\description{
Use this function to export your (pre)registration specification to an
HTML file. To instead embed it in an R Markdown file, use
\code{\link[=prereg_knit_item_content]{prereg_knit_item_content()}}.
}
\examples{
### Load an example (pre)registration specification
data("examplePrereg_1", package = "preregr");

### Convert it to HTML and show the result
preregr::prereg_spec_to_html(
  examplePrereg_1
);
}
