\name{ds.rSAC.bootstrap}
\alias{ds.rSAC.bootstrap}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  RFA estimator with bootstrap
}
\description{
\code{ds.rSAC.bootstrap} predicts the expected number of species 
represented at least \eqn{r} times in a random sample, 
based on the initial sample. 
}
\usage{
ds.rSAC.bootstrap(n, r=1, mt=20, times=30, conf=0.95)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{
    A two-column matrix.  
    The first column is the frequency \eqn{j = 1,2,\dots}; and the second column
    is \eqn{N_j}, the number of species with each species represented exactly \eqn{j}
    times in the initial sample. The first column must be sorted in an
    ascending order.
  }
  \item{r}{
    A positive integer. Default is 1.
  }
  \item{mt}{
    An positive integer constraining possible rational function
    approximations. Default is 20.
  }
  \item{times}{
    The number of bootstrap samples. Default is 30.
  }
  \item{conf}{
    The confidence level. Default is 0.95
  }
}
\details{
  This is the bootstrap version of \code{\link{ds.rSAC}}. The bootstrap
  sample is generated by randomly sampling the initial sample with replacement.
  For each bootstrap sample, we construct an estimator. The median of
  estimates is used as the prediction for the number of species
  represented at least \eqn{r} times in a random sample. 
  
  The confidence interval is constructed based on a lognormal distribution.
}
\value{
  \item{f}{
    The estimator for the number of species represented at least \eqn{r} times in 
    a random sample. The input of the estimator is a vector of sampling 
    efforts t, i.e. the relative sample sizes comparing with the initial sample.
    For example, t = 2 means a random sample that is twice the size of the 
    initial sample.
  }
  \item{se}{
    The standard error for the estimator. The input is a vector of sampling 
    efforts \eqn{t}.
  }
  \item{lb}{
    The lower bound of the confidence interval.The input is a vector of sampling 
    efforts \eqn{t}.
  }
  \item{ub}{
    The upper bound of the confidence interval.The input is a vector of sampling 
    efforts \eqn{t}.
  }
}

\references{
Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press.

Deng, C., Daley, T., Calabrese, P., Ren, J., & Smith, A.D. (2016). Estimating
the number of species to attain sufficient representation in a random sample.
arXiv preprint arXiv:1607.02804v3.
}

\author{
  Chao Deng
}

\examples{
## load library
# library(preseqR)

## import data
# data(FisherButterfly)

## construct the estimator for SAC
# ds1 <- ds.rSAC.bootstrap(FisherButterfly, r=1)
## The number of species represented at least once in a sample, 
## when the sample size is 10 or 20 times of the initial sample
# ds1$f(c(10, 20))
## The standard error of the estiamtes
# ds1$se(c(10, 20))
## The confidence interval of the estimates
# lb <- ds1$lb(c(10, 20))
# ub <- ds1$ub(c(10, 20))
# matrix(c(lb, ub), byrow=FALSE, ncol=2)

## construct the estimator for SAC
# ds2 <- ds.rSAC.bootstrap(FisherButterfly, r=2)
## The number of species represented at least twice in a sample, 
## when the sample size is 50 or 100 times of the initial sample
# ds2$f(c(50, 100))
## The standard error of the estiamtes
# ds2$se(c(50, 100))
## The confidence interval of the estimates
# lb <- ds2$lb(c(50, 100))
# ub <- ds2$ub(c(50, 100))
# matrix(c(lb, ub), byrow=FALSE, ncol=2)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ estimator, r-SAC, RFA, bootstrap, nonparametric}
