\name{kmer.frac.curve.bootstrap}
\alias{kmer.frac.curve.bootstrap}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Fraction of \eqn{k}-mers observed at least \eqn{r} times with bootstrap
}
\description{
\code{kmer.frac.curve} predicts the expected fraction of \eqn{k}-mers observed at
least \eqn{r} times in a high-throughput sequencing experiment given the 
amount of sequencing
}
\usage{
kmer.frac.curve.bootstrap(n, k, read.len, seq, r=2, mt=20, times=30, conf=0.95)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{
    A two-column matrix.  
    The first column is the frequency \eqn{j = 1,2,\dots}; and the second column
    is \eqn{N_j}, the number of \eqn{k}-mers observed exactly \eqn{j}
    times in the initial experiment. The first column must be sorted in an
    ascending order.
  }
  \item{k}{
    The number of nucleotides in a \eqn{k}-mer.
  }
  \item{read.len}{
    The average length of a read.
  }
  \item{seq}{
    The amount of nucleotides sequenced.
  }
  \item{r}{
    A positive integer. Default is 1.
  }
  \item{mt}{
    An positive integer constraining possible rational function
    approximations. Default is 20.
  }
  \item{times}{
    The number of bootstrap samples.
  }
  \item{conf}{
    The confidence level. Default is 0.95
  }
}
\details{
  This is the bootstrap version of \code{\link{kmer.frac.curve}}. The bootstrap
  sample is generated by randomly sampling the initial sample with replacement.
  For each bootstrap sample, we construct an estimator. The median of
  estimates is used as the prediction for the number of species
  represented at least \eqn{r} times in a random sample. 
  
  The confidence interval is constructed based on a lognormal distribution.
}
\value{
  A four-column matrix. The first column is the amount of sequencing in an 
  experiment.
  The second column is the estimate of the fraction of \eqn{k}-mers observed at least
  \eqn{r} times in the experiment. The third and fourth columns are the lower
  bounds and the upper bounds of the confidence intervals.
}

\references{
Efron, B., & Tibshirani, R. J. (1994). An introduction to the bootstrap. CRC press.

Deng, C., Daley, T., Calabrese, P., Ren, J., & Smith, A.D. (2016). Estimating
the number of species to attain sufficient representation in a random sample.
arXiv preprint arXiv:1607.02804v3.
}

\author{
  Chao Deng
}

\examples{
## load library
# library(preseqR)

## import data
# data(SRR061157_k31)

## the fraction of 31-mers represented at least 10 times in an experiment when
## sequencing 1M, 10M, 100M, 1G, 10G, 100G, 1T nucleotides
# kmer.frac.curve.bootstrap(n=SRR061157_k31, k=31, read.len=100, 
#                          seq=10^(6:12), r=10, mt=20) 
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{k-mer, sample coverage, bootstrap, high-throughput, Metagenomics}
