% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_cw.R
\name{dm_cw}
\alias{dm_cw}
\title{Diebold-Mariano Test and Clark & West  Test}
\usage{
dm_cw(Ehat1, Ehat2)
}
\arguments{
\item{Ehat1}{Residual series from Model 1 (the smaller model). One dimension and numeric.}

\item{Ehat2}{Residual series from Model 2 (the larger/nested model). One dimension and numeric.}
}
\value{
A list of  statistics and corresponding P values will be produced.
}
\description{
It calculates the original DM statistics and the CW adjusted version of DM statistics, including the versions based on a Newey-West type estimator of the long run variance.
}
\examples{
e1<- rnorm(15);
e2<- rnorm(15);
temp1 <- dm_cw(e1,e2)

}
\references{
Clark, T. E., & West, K. D. (2007). Approximately normal tests for equal predictive accuracy in nested models. Journal of econometrics, 138(1), 291-311.

Diebold, F. X., & Mariano, R. S. (1995). Com paring predictive accu racy. Journal of Business and Economic Statistics, 13(3), 253-263.
}
