% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precise_ptp.R
\name{calculate_precise_2021_clinical_ptp}
\alias{calculate_precise_2021_clinical_ptp}
\title{Calculate 2021 PRECISE Clinical PTP for obstructive CAD}
\usage{
calculate_precise_2021_clinical_ptp(
  age,
  sex,
  chest_pain_type,
  have_neck_radiation,
  have_diabetes,
  have_hypertension,
  smoking_history_type,
  have_q_waves,
  have_st_t_changes,
  label_sex_male = c("male"),
  label_sex_female = c("female"),
  label_sex_unknown = c(NA, NaN),
  label_cpt_nonanginal = c("nonanginal"),
  label_cpt_atypical = c("atypical"),
  label_cpt_typical = c("typical"),
  label_cpt_unknown = c(NA, NaN),
  label_have_neck_radiation_no = c("no"),
  label_have_neck_radiation_yes = c("yes"),
  label_have_neck_radiation_unknown = c(NA, NaN),
  label_have_diabetes_no = c("no"),
  label_have_diabetes_yes = c("yes"),
  label_have_diabetes_unknown = c(NA, NaN),
  label_have_hypertension_no = c("no"),
  label_have_hypertension_yes = c("yes"),
  label_have_hypertension_unknown = c(NA, NaN),
  label_smoking_history_type_current = c("current"),
  label_smoking_history_type_past = c("past"),
  label_smoking_history_type_none = c("none"),
  label_smoking_history_type_unknown = c(NA, NaN),
  label_have_q_waves_no = c("no"),
  label_have_q_waves_yes = c("yes"),
  label_have_q_waves_unknown = c(NA, NaN),
  label_have_st_t_changes_no = c("no"),
  label_have_st_t_changes_yes = c("yes"),
  label_have_st_t_changes_unknown = c(NA, NaN)
)
}
\arguments{
\item{age}{Input numeric value to indicate the age of the patient in years.}

\item{sex}{The value of variable in the parameters \code{label_sex_male},
\code{label_sex_female} and \code{label_sex_unknown}.}

\item{chest_pain_type}{The value of variable in the parameters,
\code{label_cpt_nonanginal}, \code{label_cpt_atypical}, \code{label_cpt_typical} and
\code{label_cpt_unknown}.}

\item{have_neck_radiation}{The value of variable in the parameters
\code{label_have_neck_radiation_no}, \code{label_have_neck_radiation_yes}
and \code{label_have_neck_radiation_unknown}.}

\item{have_diabetes}{The value of variable in the parameters
\code{label_have_diabetes_no}, \code{label_have_diabetes_yes}
and \code{label_have_diabetes_unknown}.}

\item{have_hypertension}{The value of variable in the parameters
\code{label_have_hypertension_no}, \code{label_have_hypertension_yes}
and \code{label_have_hypertension_unknown}.}

\item{smoking_history_type}{The value of variable in the parameters
\code{label_smoking_history_type_current}, \code{label_smoking_history_type_past},
\code{label_smoking_history_type_none} and \code{label_smoking_history_type_unknown}}

\item{have_q_waves}{The value of variable in the parameters
\code{label_have_q_waves_no}, \code{label_have_q_waves_yes}
and \code{label_have_q_waves_unknown}.}

\item{have_st_t_changes}{The value of variable in the parameters
\code{label_have_st_t_changes_no}, \code{label_have_st_t_changes_yes}
and \code{label_have_st_t_changes_unknown}.}

\item{label_sex_male}{Label(s) for definition(s) of male sex.
Default: \code{c("male")}}

\item{label_sex_female}{Label(s) for definition(s) of female sex.
Default: \code{c("female")}}

\item{label_sex_unknown}{Label(s) for definition(s) of missing sex.
Default: \code{c(NA, NaN)}}

\item{label_cpt_nonanginal}{Label(s) for patient having nonanginal or non-specific chest pain.
Default: \code{c("nonanginal")}}

\item{label_cpt_atypical}{Label(s) for patient having atypical chest pain.
Default: \code{c("atypical")}}

\item{label_cpt_typical}{Label(s) for patient having typical chest pain.
Default: \code{c("typical")}}

\item{label_cpt_unknown}{Label(s) for patient having unknown chest pain type symptoms.
Default: \code{c(NA, NaN)}}

\item{label_have_neck_radiation_no}{Label(s) for patient without
chest pain radiating to the neck.
Default: \code{c("no")}}

\item{label_have_neck_radiation_yes}{Label(s) for patient with
chest pain radiating to the neck.
Default: \code{c("yes")}}

\item{label_have_neck_radiation_unknown}{Label(s) for patient with unknown
chest pain radiating to the neck
Default: \code{c(NA, NaN)}}

\item{label_have_diabetes_no}{Label(s) for patient with no diabetes.
Default: \code{c("no")}}

\item{label_have_diabetes_yes}{Label(s) for patient having diabetes.
Default: \code{c("yes")}}

\item{label_have_diabetes_unknown}{Label(s) for patient
having unknown diabetes.
Default: \code{c(NA, NaN)}}

\item{label_have_hypertension_no}{Label(s) for patient with no hypertension.
Default: \code{c("no")}}

\item{label_have_hypertension_yes}{Label(s) for patient having hypertension.
Default: \code{c("yes")}}

\item{label_have_hypertension_unknown}{Label(s) for patient
having unknown hypertension.
Default: \code{c(NA, NaN)}}

\item{label_smoking_history_type_current}{Label(s) for patient who is a current smoker.
Default: \code{c("current")}}

\item{label_smoking_history_type_past}{Label(s) for patient who is a past smoker.
Default: \code{c("past")}}

\item{label_smoking_history_type_none}{Label(s) for patient who is a non-smoker.
Default: \code{c("none")}}

\item{label_smoking_history_type_unknown}{Label(s) for patient with unknown smoking history.
Default: \code{c(NA, NaN)}}

\item{label_have_q_waves_no}{Label(s) for patient not having Q waves on ECG.
Default: \code{c("no")}}

\item{label_have_q_waves_yes}{Label(s) for patient having Q waves on ECG.
Default: \code{c("yes")}}

\item{label_have_q_waves_unknown}{Label(s) for patient with unknown Q waves on ECG.
Default: \code{c(NA, NaN)}}

\item{label_have_st_t_changes_no}{Label(s) for patient not having ST-T changes on ECG.
Default: \code{c("no")}}

\item{label_have_st_t_changes_yes}{Label(s) for patient having ST-T changes on ECG.
Default: \code{c("yes")}}

\item{label_have_st_t_changes_unknown}{Label(s) for patient with unknown ST-T changes on ECG.
Default: \code{c(NA, NaN)}}
}
\value{
A numeric value representing the patient's PTP for obstructive CAD
based on the 2021 Predictive Risk scorE for CAD In Southeast Asians
with chEst pain (PRECISE) clinical model.
}
\description{
This function returns a patient's
pre-test probability (PTP) of obstructive
coronary artery disease based on the
2021 Predictive Risk scorE for CAD In Southeast Asians with chEst pain
(PRECISE) clinical model.
}
\details{
The predictive model is based on
patients a mixed Asian cohort within Singapore with stable chest pain.
}
\examples{
# 40 year old female with typical chest pain
# radiating to the neck, has diabetes
# but no hypertension and a non-smoker.
# She has Q waves but no ST-T changes on ECG.

calculate_precise_2021_clinical_ptp(
    age = 40,
    sex = "female",
    chest_pain_type = "typical",
    have_neck_radiation = "yes",
    have_diabetes = "yes",
    have_hypertension = "no",
    smoking_history_type = "none",
    have_q_waves = "yes",
    have_st_t_changes = "no"
)
}
