% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/primer-package.R
\docType{data}
\name{moths}
\alias{moths}
\title{Moth Species Richness}
\format{
A data frame with 21 observations on the following 6 variables.
\describe{ \item{region}{a factor with levels \code{NCT} \code{WAP}
for the two collection regions.} \item{site}{a factor with levels
associated with county names.} \item{area}{a numeric vector for the
area of each forest fragment} \item{spp}{a numeric vector, the
number of moth species.} \item{lat}{a numeric vector; latitude}
\item{long}{a numeric vector; longitude} }
}
\source{
Data proided graciously by Keith Summerville and Thomas Crist; see
"A Primer of Ecology with R" for specific references.
}
\description{
Data set of moth species richness from Ohio and Indiana, USA.
}
\examples{

data(moths)
plot(spp ~ area, data=moths)

}
\references{
K. S. Summerville and T. O. Crist. 2003. Determinants of
lepidopteran community composition and species diversity in eastern
deciduous forests: roles of season, ecoregion and patch size. \emph{Oikos},
100:134-148.

K. S. Summerville and T. O. Crist. 2004. Contrasting effects of habitat
quantity and quality on moth communities in fragmented landscapes.
\emph{Ecography}, 27:3-12.
}
\keyword{datasets}
