% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/one_over_f.R
\name{one_over_f}
\alias{one_over_f}
\title{Function to generate 1/f noise.}
\usage{
one_over_f(gamma = 1, N = 200)
}
\arguments{
\item{gamma}{spectral power, numeric, where 0 generates a white noise time series, 2 generates reddened noise. Defaults to 1 (pink).}

\item{N}{length of the time series.}
}
\description{
Generates 1/f noise with a specified power or amplitude.
}
\examples{

set.seed(1)
time.series <- one_over_f(gamma=2, N=50)
plot(1:50, time.series, type='l', main="Reddened noise")
time.series <- one_over_f(gamma=0, N=50)
plot(1:50, time.series, type='l', main="White noise")
one_over_f()

}
\references{
J. M. Halley. Ecology, evolution and 1/f-noise. Trends in Ecology & Evolution, 11:33-37, 1996.
O. L. Petchey, A. Gonzalez, and H. B. Wilson. Effects on population persistence: the interaction between environmental noise colour, intra-specific competition and space. Proceedings of the Royal Society of London Series B, 264:1841-1847, 1997.
J. E. Cohen, C. M. Newman, A. E. Cohen, O. L. Petchey, and A. Gonzalez. Spectral mimicry: a method of synthesizing matching time series with different Fourier spectra. Circuits, Systems and Signal Processing, 18:431-442, 1999.
}
\seealso{
[spec_mimic()] to rearrange one vector, X, to mimic the spectrum of another vector, Y; [plot_f()] to plot the time series and the spectrogram of the series.
}
\author{
Hank Stevens
}
\keyword{1/f}
\keyword{color}
\keyword{noise}
\keyword{spectra}
