% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_get_md.R
\name{pd_get_md}
\alias{pd_get_md}
\title{Get prism metadata}
\usage{
pd_get_md(pd)
}
\arguments{
\item{pd}{prism data character vector.}
}
\value{
data.frame containing metadata for all specified prism data.
}
\description{
Retrieves prism metadata from the specified prism data. "prism data", i.e.,
\code{pd} are the folder names returned by \code{\link[=prism_archive_ls]{prism_archive_ls()}} or
\code{\link[=prism_archive_subset]{prism_archive_subset()}}. These functions get the name or date from these
data, or convert these data to a file name. A warning is provided if the
specified prism data do not exist in the archive.
}
\details{
The metadata includes the following variables from the .info.txt file for
daily, monthly, and annual data:
\itemize{
\item PRISM_DATASET_FILENAME
\item PRISM_DATASET_CREATE_DATE
\item PRISM_DATASET_TYPE
\item PRISM_DATASET_VERSION
\item PRISM_CODE_VERSION
\item PRISM_DATASET_REMARKS
}

Additionally, two local variables are added identifying where the file is
located on the local system:
\itemize{
\item file_path
\item folder_path
}

The annual and monthly normals data includes different keys in
the .info.txt, so they are renamed to be the same as those found in the
other temporal data. The keys/variables are renamed as follows:
\itemize{
\item PRISM_FILENAME --> PRISM_DATASET_FILENAME
\item PRISM_CREATE_DATE --> PRISM_DATASET_CREATE_DATE
\item PRISM_DATASET --> PRISM_DATASET_TYPE
\item PRISM_VERSION --> PRISM_CODE_VERSION
\item PRISM_REMARKS --> PRISM_DATASET_REMARKS
}

Additionally, the normals does not include PRISM_DATASET_VERSION, so that
variable is added with \code{NA} values.
}
\examples{
\dontrun{
#' # Assumes 2000-2002 annual precipitation data is already downloaded
pd <- prism_archive_subset('ppt', 'annual', years = 2000:2002)
df <- pd_get_md(pd)
head(df)
}

}
