% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{noorder}
\alias{noorder}
\title{Sort and Merge Probability Space Outcomes}
\usage{
noorder(space)
}
\arguments{
\item{space}{a data frame probability space or a subset of one.}
}
\value{
A data frame with a \code{probs} column and sorted, unique rows.
}
\description{
This function sorts the rows (outcomes) of a data frame probability space, effectively removing the original order present and aggregates the sorted rows into a new probability data frame with unique, sorted outcomes.
}
\details{
The data frame \code{space} must have at least two non-\code{probs} columns or an error will result.
}
\examples{
S <- tosscoin(3, makespace = TRUE)
noorder(S)

}
\seealso{
\code{\link[probs]{addrv}}, \code{\link[probs]{marginal}}
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
\keyword{misc}
