% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{sim}
\alias{sim}
\alias{sim.default}
\alias{sim.ps}
\title{Simulate Draws from a Sample Space}
\usage{
sim(x, ...)

\method{sim}{default}(x, ntrials, ...)

\method{sim}{ps}(x, ntrials, ...)
}
\arguments{
\item{x}{a probability space or a subset of one.}

\item{...}{further arguments to be passed to or from other methods.}

\item{ntrials}{number of times to repeat the experiment.}
}
\value{
A data frame if \code{space} is a data frame, or a list if \code{space} is of class \code{ps}.

A data frame if \code{space} is a data frame, or a list if \code{space} is of class \code{ps}.

A data frame if \code{space} is a data frame, or a list if \code{space} is of class \code{ps}.
}
\description{
Simulates the experiment of drawing from a sample space.

Simulates the experiment of drawing from a sample space.

Simulates the experiment of drawing from a sample space.
}
\details{
The \code{sim()} function is a wrapper for \code{sample()}, except that it strips the \code{probs} component from the result and (if \code{x} is a data frame) renames the rownames of the data frame consecutively from \code{1:ntrials}.

The \code{sim()} function is a wrapper for \code{sample()}, except that it strips the \code{probs} component from the result and (if \code{x} is a data frame) renames the rownames of the data frame consecutively from \code{1:ntrials}.

The \code{sim()} function is a wrapper for \code{sample()}, except that it strips the \code{probs} component from the result and (if \code{x} is a data frame) renames the rownames of the data frame consecutively from \code{1:ntrials}.
}
\examples{
S <- cards(makespace = TRUE)
sim(S, ntrials = 5)

T <- urnsamples(S, 2)
U <- probspace(T)
sim(U, ntrials = 4)

S <- cards(makespace = TRUE)
sim(S, ntrials = 5)

T <- urnsamples(S, 2)
U <- probspace(T)
sim(U, ntrials = 4)

S <- cards(makespace = TRUE)
sim(S, ntrials = 5)

T <- urnsamples(S, 2)
U <- probspace(T)
sim(U, ntrials = 4)

}
\seealso{
\code{\link[probs]{empirical}}

\code{\link[probs]{empirical}}

\code{\link[probs]{empirical}}
}
\author{
G. Jay Kerns \email{gkerns@ysu.edu}.
}
\keyword{misc}
