% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/absent.R
\name{absent}
\alias{absent}
\title{Absent}
\usage{
absent(activity, n = 0)
}
\arguments{
\item{activity}{\code{\link{character}}: The activity to check. This should be an activity of the log supplied to \code{\link{check_rule}}.}

\item{n}{\code{\link{numeric}} (default \code{0}): The allowed number of occurences of the activity, e.g. \code{n = 0} means the activity should be absent,
\code{n = 1} means it is allowed to occur once.}
}
\description{
Check if the specified activity is absent from a case.

The \code{absent} rule can be used to check whether an activity is absent in a case or not. The \code{n} parameter can be configured to create a different level of \emph{absence}.
When \code{n = 0}, an activity is not allowed to occur even a single time. The maximum number of times it is allowed to occur is \code{n}.
}
\examples{
library(bupaR)
library(eventdataR)

# Check for which patients the activity "MRI SCAN" is absent.
patients \%>\%
 check_rule(absent("MRI SCAN"))

# Check for which patients the activity "Blood test" occurs maximum a single time,
# but not 2 times or more.
patients \%>\%
 check_rule(absent("Blood test", n = 1))

}
\seealso{
Other Cardinality rules: 
\code{\link{contains}()},
\code{\link{contains_between}()},
\code{\link{contains_exactly}()}
}
\concept{Cardinality rules}
