% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_next_good_datapoint.R
\name{find_next_good_datapoint}
\alias{find_next_good_datapoint}
\title{What Is the Next Non-Null Data Point?}
\usage{
find_next_good_datapoint(data_row, index, n_replicates)
}
\arguments{
\item{data_row}{A numeric vector representing the data row.}

\item{index}{The index of the current data point.}

\item{n_replicates}{The total number of replicates (length of the row)}
}
\value{
The next good data point or -999 if none is found.
}
\description{
What Is the Next Non-Null Data Point?
}
\details{
Given a data row, an index, and the number of replicates (the number of elements in the row),
this function finds the next good data point in the row.

A good data point is a non-missing value (not NA) with a non-empty string.
}
\examples{
data_row <- c(NA, 3, 2, NA, 5)
index <- 1
n_replicates <- 5
find_next_good_datapoint(data_row, index, n_replicates) # expect 3

}
