% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_range.R
\name{query_range}
\alias{query_range}
\title{Evaluate an expression query over a range of time.}
\usage{
query_range(
  query,
  start,
  end,
  host = "http://127.0.0.1:9090",
  step = "10s",
  timeout = NA
)
}
\arguments{
\item{query}{A PromQL query.}

\item{start}{A RFC3339 timestamp string, numerical unix timestamp, or POSIXct
object.}

\item{end}{A RFC3339 timestamp string, numerical unix timestamp, or POSIXct
object.}

\item{host}{An optional host - defaulting to \verb{http://127.0.0.1:9090}}

\item{step}{An optional query resolution step width, defaulting to \verb{10s}}

\item{timeout}{An optional query timeout value, defaulting to server-side
limit. Note this timeout is capped to the server-side value.}
}
\value{
A tibble of all series returned by the server, with nested
measurements.
}
\description{
Evaluate an expression query over a range of time.
}
\examples{
\dontrun{
# Run a simple range query against the specified host.
query_range(
  "up",
  "2022-08-20T00:00:00Z",
  "2022-08-21T00:00:00Z",
  host = "http://127.0.0.1:9090"
)

# Run a server-side aggregation query, using the default local host.
query_range(
  "rate(http_requests_total[5m])",
  "2022-08-20T00:00:00Z",
  "2022-08-21T00:00:00Z"
)

# Specify the time range using POSIXct objects, and set the optional "step"
query_range(
  "rate(http_requests_total[5m])",
  strptime(
    "2022-08-20T20:10:30",
    format = "\%Y-\%m-\%dT\%H:\%M:\%S"
  ),
  strptime(
    "2022-08-21T20:10:30",
    format = "\%Y-\%m-\%dT\%H:\%M:\%S"
  ),
  step = "30s"
)

# Specify the time range using unix timestamps, and set an optional "timeout"
query_range(
  "rate(http_requests_total[5m])",
  1660989814,
  1661076214,
  timeout = "60s"
)
}
}
