% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divisor_methods.R
\name{highest_averages_method}
\alias{highest_averages_method}
\title{Highest averages method}
\usage{
highest_averages_method(votes, n_seats, divisors)
}
\arguments{
\item{votes}{numeric vector with number of votes for each party}

\item{n_seats}{total number of seats}

\item{divisors}{sequence of divisors (length equal to the number of seats).
If it is a single number (e.g. 0.5), a sequence is generated
starting with it, increasing by 1.}
}
\value{
The number of seats per party as a vector
}
\description{
Allocate seats proportionally for \code{\link[=divisor_methods]{divisor methods}}.
}
\details{
The highest averages method requires the number of votes for each party to
be divided successively by a series of divisors. This produces a table of
quotients, or averages, with a row for each divisor and a column for each
party. The nth seat is allocated to the party whose column contains the nth
largest entry in this table, up to the total number of seats
available. (\href{https://en.wikipedia.org/wiki/Highest_averages_method}{Wikipedia})
}
\examples{
highest_averages_method(c(5200, 1700, 3100), 15, 0.5)

highest_averages_method(votes = c(50, 0, 30), n_seats = 3,
                        divisors = c(0, 1.3333, 2.4))
}
