% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/debugLine.R, R/debugState.R, R/debugVariable.R
\name{debug.line}
\alias{debug.line}
\alias{debug.state}
\alias{debug.variable}
\title{Displaying variable values}
\usage{
debug.line(..., script.num = 1, all = FALSE)

debug.state(..., script.num = 1, showType = FALSE)

debug.variable(
  ...,
  val.type = "all",
  script.num = "all",
  all = FALSE,
  showType = FALSE
)
}
\arguments{
\item{...}{The variable names to be queried.}

\item{script.num}{The script number of the queried variables. Defaults to "all".}

\item{all}{If TRUE, results for all variables of the specified script will be
returned.}

\item{showType}{If TRUE, variable container, dimension, and type are displayed.}

\item{val.type}{If not "all", this filters the results to contain
only instances where the valType (container or type) has the
queried type. Only one type may be queried per function call.}
}
\value{
debug.line returns a list of data frames showing the inputs and outputs for the procedure
        in each line queried.

debug.state returns a list of data frames of states for each queried line number, or the state
        at the end of execution if no parameters are given to the function.

debug.variable returns a list of data frames showing all instances of each variable queried.
}
\description{
debug.line displays the values of variables that are either used or set
on a particular line.

debug.state displays the values of all variables in the global environment 
after execution of a particular line.

debug.variable shows all values that a particular variable has during 
execution of a script.
}
\details{
These functions are part of the provDebugR package.  To use them, you must
first initialise the debugger using
one its initialisation functions: \code{\link{prov.debug}}, 
\code{\link{prov.debug.file}}, or \code{\link{prov.debug.run}}.

For each line number queried, debug.line returns a data frame of the data 
that the procedure in that line inputs and outputs.
Each data frame contains the following columns:
\itemize{
	\item name: The name of the data.
	\item value: The value of the data.
	\item container: The type of the container of the data, such as vector or data frame.
	\item dimension: The size of the container.
	\item type: The data type(s) contained within the container.
}

For each queried line, debug.state returns a data frame showing the state
at that line, after it has been executed.
Each data frame contains the following columns:
\itemize{
	\item name: The names of variables in the state.
	\item value: The value of each variable.
	\item container: The type of the container of each variable.
	\item dimension: The size of the container.
	\item type: The data type(s) contained within the container.
	\item scriptNum: The script number associated with each variable.
 	\item scriptName: The name of the script the variable is associated with.
	\item startLine: The line number associated with each variable.
}
If no paramters are given, debug.state will return the state at the end of
execution.

For each variable queried, debug.variable returns a data frame of all
instances (data nodes) of that variable.
Each data frame contains the following columns:
\itemize{
	\item value: The value of the variable.
	\item container: The type of the container of the variable.
	\item dimension: The size of the container.
	\item type: The data type(s) contained within the container.
	\item scriptNum: The script number the variable is associated with.
 	\item scriptName: The name of the script the variable or file is associated with.
	\item startLine: The line number the variable is associated with.
	\item code: The code this variable is associated with.
}
}
\examples{
\dontrun{
prov.debug.run("test.R")
debug.line(5)
debug.line(all = TRUE)
debug.line(5, 10, script.num = 2)
debug.line(3, script.num = "all")
}

\dontrun{
prov.debug.run("test.R")
debug.state()
debug.state(5)
debug.state(10, 20, script.num = 2)
debug.state(5, script.num = "all")
}

\dontrun{
prov.debug.run("test.R")
debug.variable(x)
debug.variable(all = TRUE)
debug.variable("a", b, "x", val.type = "logical")
debug.variable("a", "b", x, script.num = 3)
}

}
\seealso{
provDebugR Initialisation Functions:

\code{\link{prov.debug}}

\code{\link{prov.debug.file}}

\code{\link{prov.debug.run}}

Other provDebugR Functions (non-initialisation):

\code{\link{debug.error}}: Returns the backwards lineage of the error, if any.
             The error may be queried on StackOverflow.

\code{\link{debug.lineage}}: Returns the forwards or backwards lineage
             of the data object(s) queried. The forwards lineage shows how the
             data object was used, and the backwards lineage shows how it was produced.

\code{\link{debug.type.changes}}: Returns a data frame for each variable in
             the execution containing the instances where the data type changed.

\code{\link{debug.warning}}: Returns the backwards lineage of the queried
             warning(s), if any.
}
