/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.swf;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import org.freehep.graphicsio.swf.DefinitionTag;
import org.freehep.graphicsio.swf.SWFInputStream;
import org.freehep.graphicsio.swf.SWFOutputStream;
import org.freehep.graphicsio.swf.SWFTag;

public class DefineEditText
extends DefinitionTag {
    private int character;
    private Rectangle2D bounds;
    private boolean disableEditting;
    private boolean password;
    private boolean multiLine;
    private boolean wordWrap;
    private boolean drawBox;
    private boolean disableSelection;
    private int fontID;
    private int height;
    private Color color;
    private int maxLength = -1;
    private int alignment;
    private int leftMargin;
    private int rightMargin;
    private int indent;
    private int lineSpace;
    private String variable;
    private String initialText;

    public DefineEditText() {
        super(37, 4);
    }

    @Override
    public SWFTag read(int tagID, SWFInputStream swf, int len) throws IOException {
        DefineEditText tag = new DefineEditText();
        tag.character = swf.readUnsignedShort();
        swf.getDictionary().put(tag.character, tag);
        tag.bounds = swf.readRect();
        int flags = swf.readUnsignedShort();
        boolean hasLength = (flags & 2) > 0;
        tag.disableEditting = (flags & 8) > 0;
        tag.password = (flags & 0x10) > 0;
        tag.multiLine = (flags & 0x20) > 0;
        tag.wordWrap = (flags & 0x40) > 0;
        boolean hasText = (flags & 0x80) > 0;
        tag.drawBox = (flags & 0x800) > 0;
        tag.disableSelection = (flags & 0x1000) > 0;
        tag.fontID = swf.readUnsignedShort();
        tag.height = swf.readUnsignedShort();
        tag.color = swf.readColor(true);
        if (hasLength) {
            tag.maxLength = swf.readUnsignedShort();
        }
        tag.alignment = swf.readUnsignedByte();
        tag.leftMargin = swf.readUnsignedShort();
        tag.rightMargin = swf.readUnsignedShort();
        tag.indent = swf.readUnsignedShort();
        tag.lineSpace = swf.readUnsignedShort();
        tag.variable = swf.readString();
        if (hasText) {
            tag.initialText = swf.readString();
        }
        return tag;
    }

    @Override
    public void write(int tagID, SWFOutputStream swf) throws IOException {
        swf.writeUnsignedShort(this.character);
        swf.writeRect(this.bounds);
        int flags = 0;
        if (this.maxLength >= 0) {
            flags |= 2;
        }
        if (this.disableEditting) {
            flags |= 8;
        }
        if (this.password) {
            flags |= 0x10;
        }
        if (this.multiLine) {
            flags |= 0x20;
        }
        if (this.wordWrap) {
            flags |= 0x40;
        }
        if (this.initialText != null) {
            flags |= 0x80;
        }
        if (this.drawBox) {
            flags |= 0x800;
        }
        if (this.disableSelection) {
            flags |= 0x1000;
        }
        swf.writeUnsignedShort(flags);
        swf.writeUnsignedShort(this.fontID);
        swf.writeUnsignedShort(this.height);
        swf.writeColor(this.color, true);
        if (this.maxLength >= 0) {
            swf.writeUnsignedShort(this.maxLength);
        }
        swf.writeUnsignedByte(this.alignment);
        swf.writeUnsignedShort(this.leftMargin);
        swf.writeUnsignedShort(this.rightMargin);
        swf.writeUnsignedShort(this.indent);
        swf.writeUnsignedShort(this.lineSpace);
        swf.writeString(this.variable);
        if (this.initialText != null) {
            swf.writeString(this.initialText);
        }
    }

    @Override
    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(super.toString() + "\n");
        s.append("  character:  " + this.character + "\n");
        s.append("  ...\n");
        return s.toString();
    }
}

