% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppdpps.R
\name{graph_psm_survs}
\alias{graph_psm_survs}
\title{Graph the PSM survival functions}
\usage{
graph_psm_survs(timevar, endpoint, ptdata, dpam, psmtype)
}
\arguments{
\item{timevar}{Vector of times at which to calculate the hazards}

\item{endpoint}{Endpoint for which hazard is required (TTP, PPD, PFS, OS or PPS)}

\item{ptdata}{Dataset of patient level data. Must be a tibble with columns named:
\itemize{
\item \code{ptid}: patient identifier
\item \code{pfs.durn}: duration of PFS from baseline
\item \code{pfs.flag}: event flag for PFS (=1 if progression or death occurred, 0 for censoring)
\item \code{os.durn}: duration of OS from baseline
\item \code{os.flag}: event flag for OS (=1 if death occurred, 0 for censoring)
\item \code{ttp.durn}: duration of TTP from baseline (usually should be equal to pfs.durn)
\item \code{ttp.flag}: event flag for TTP (=1 if progression occurred, 0 for censoring).
}}

\item{dpam}{List of survival regressions for each endpoint:
\itemize{
\item pre-progression death (PPD)
\item time to progression (TTP)
\item progression-free survival (PFS)
\item overall survival (OS)
\item post-progression survival clock forward (PPS-CF) and
\item post-progression survival clock reset (PPS-CR).
}}

\item{psmtype}{Either "simple" or "complex" PSM formulation}
}
\value{
List containing:
\itemize{
\item \code{adj} is the hazard adjusted for constraints
\item \code{unadj} is the unadjusted hazard
}
}
\description{
Graph the PSM survival functions
}
\examples{
\donttest{
bosonc <- create_dummydata("flexbosms")
fits <- fit_ends_mods_par(bosonc)
# Pick out best distribution according to min AIC
params <- list(
  ppd = find_bestfit(fits$ppd, "aic")$fit,
  ttp = find_bestfit(fits$ttp, "aic")$fit,
  pfs = find_bestfit(fits$pfs, "aic")$fit,
  os = find_bestfit(fits$os, "aic")$fit,
  pps_cf = find_bestfit(fits$pps_cf, "aic")$fit,
  pps_cr = find_bestfit(fits$pps_cr, "aic")$fit
)
# Graphic illustrating effect of constraints on OS model
psms_simple <- graph_psm_survs(
  timevar=6*(0:10),
  endpoint="OS",
  ptdata=bosonc,
  dpam=params,
  psmtype="simple"
)
psms_simple$graph
}
}
