#' Second order meta-analysis of operational validities of big five personality measures across East Asian countries
#'
#' Example of a second-order meta-analysis of correlations corrected using artifact-distribution methods.
#'
#' @docType data
#'
#' @usage data(data_r_oh_2009)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' Oh, I. -S. (2009).
#' \emph{The Five-Factor Model of personality and job performance in East Asia: A cross-cultural validity generalization study}.
#' (Doctoral dissertation) Iowa City, IA: University of Iowa. \url{https://www.proquest.com/dissertations/docview/304903943/}
#'
#' Schmidt, F. L., & Oh, I.-S. (2013).
#' Methods for second order meta-analysis and illustrative applications.
#' \emph{Organizational Behavior and Human Decision Processes, 121}(2), 204–218. \doi{10.1016/j.obhdp.2013.03.002}
#'
#' @examples
#' data(data_r_oh_2009)
"data_r_oh_2009"



#' Meta-analysis of OCB correlations with other constructs
#'
#' Data set to demonstrate corrections for univariate range restriction and measurement error using
#' individual corrections or artifact distributions.
#' NOTE: This is an updated version of the data set reported in the Gonzalez-Mulé, Mount, an Oh (2014) article that was obtained from the first author.
#'
#' @docType data
#'
#' @usage data(data_r_gonzalezmule_2014)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' Gonzalez-Mulé, E., Mount, M. K., & Oh, I.-S. (2014).
#' A meta-analysis of the relationship between general mental ability and nontask performance.
#' \emph{Journal of Applied Psychology, 99}(6), 1222–1243. \doi{10.1037/a0037547}
#'
#' @examples
#' data(data_r_gonzalezmule_2014)
"data_r_gonzalezmule_2014"





#' Artifact-distribution meta-analysis of the validity of interviews
#'
#' Data set to demonstrate corrections for univariate range restriction and criterion measurement error using artifact distributions.
#'
#' @docType data
#'
#' @usage data(data_r_mcdaniel_1994)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' McDaniel, M. A., Whetzel, D. L., Schmidt, F. L., & Maurer, S. D. (1994).
#' The validity of employment interviews: A comprehensive review and meta-analysis.
#' \emph{Journal of Applied Psychology, 79}(4), 599–616. \doi{10.1037/0021-9010.79.4.599}
#'
#' @examples
#' data(data_r_mcdaniel_1994)
"data_r_mcdaniel_1994"






#' Artifact-distribution meta-analysis of the correlation between school grades and cognitive ability
#'
#' Data set to demonstrate corrections for univariate range restriction and cognitive ability measurement error.
#'
#' @docType data
#'
#' @usage data(data_r_roth_2015)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' Roth, B., Becker, N., Romeyke, S., Schäfer, S., Domnick, F., & Spinath, F. M. (2015).
#' Intelligence and school grades: A meta-analysis.
#' \emph{Intelligence, 53}, 118–137. \doi{10.1016/j.intell.2015.09.002}
#'
#' @examples
#' data(data_r_roth_2015)
"data_r_roth_2015"






#' Bare-bones meta-analysis of parenting and childhood depression
#'
#' Data set to demonstrate bare-bones meta-analysis.
#'
#' @docType data
#'
#' @usage data(data_r_mcleod_2007)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @references
#' McLeod, B. D., Weisz, J. R., & Wood, J. J., (2007).
#' Examining the association between parenting and childhood depression:  A meta-analysis.
#' \emph{Clinical Psychology Review, 27}(8), 986–1003. \doi{10.1016/j.cpr.2007.03.001}
#'
#' @examples
#' data(data_r_mcleod_2007)
"data_r_mcleod_2007"




#### Simulated datasets ####

#' Hypothetical dataset simulated to satisfy the assumptions of the correction for measurement error only
#'
#' Data set for use in example meta-analyses correcting for measurement error in two variables.
#'
#' @docType data
#'
#' @usage data(data_r_meas)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_meas)
"data_r_meas"



#' Hypothetical dataset simulated to satisfy the assumptions of the univariate correction for direct range restriction
#'
#' Data set for use in example meta-analyses correcting for univariate direct range restriction.
#'
#' @docType data
#'
#' @usage data(data_r_uvdrr)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_uvdrr)
"data_r_uvdrr"



#' Hypothetical dataset simulated to satisfy the assumptions of the univariate correction for indirect range restriction
#'
#' Data set for use in example meta-analyses correcting for univariate indirect range restriction.
#'
#' @docType data
#'
#' @usage data(data_r_uvirr)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_uvirr)
"data_r_uvirr"



#' Hypothetical dataset simulated to satisfy the assumptions of the bivariate correction for indirect range restriction
#'
#' Data set for use in example meta-analyses of bivariate indirect range restriction.
#'
#' @docType data
#'
#' @usage data(data_r_bvirr)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_bvirr)
"data_r_bvirr"



#' Hypothetical dataset simulated to satisfy the assumptions of the bivariate correction for direct range restriction
#'
#' Data set for use in example meta-analyses of bivariate direct range restriction.
#' Note that the BVDRR correction is only an approximation of the appropriate range-restriction correction and tends to have a noticeable positive bias when applied in meta-analyses.
#'
#' @docType data
#'
#' @usage data(data_r_bvdrr)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_bvdrr)
"data_r_bvdrr"





#' Hypothetical correlation dataset simulated to satisfy the assumptions of the correction for measurement error only in multiple constructs
#'
#' Data set for use in example meta-analyses correcting for measurement error in multiple variables.
#'
#' @docType data
#'
#' @usage data(data_r_meas_multi)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_r_meas_multi)
"data_r_meas_multi"



#' Hypothetical \emph{d} value dataset simulated to satisfy the assumptions of the correction for measurement error only in multiple constructs
#'
#' Data set for use in example meta-analyses correcting for measurement error in multiple variables.
#'
#' @docType data
#'
#' @usage data(data_d_meas_multi)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_d_meas_multi)
"data_d_meas_multi"



#' Hypothetical \emph{d} value dataset simulated with sampling error only
#'
#' Data set for use in example meta-analyses of multiple variables.
#'
#' @docType data
#'
#' @usage data(data_d_bb_multi)
#'
#' @format data.frame
#'
#' @keywords datasets
#'
#' @examples
#' data(data_d_bb_multi)
"data_d_bb_multi"



