% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/composites.R
\name{composite_rel_matrix}
\alias{composite_rel_matrix}
\title{Matrix formula to estimate the reliability of a weighted or unweighted composite variable}
\usage{
composite_rel_matrix(rel_vec, r_mat, sd_vec, wt_vec = rep(1, length(rel_vec)))
}
\arguments{
\item{rel_vec}{Vector of reliabilities associated with variables in the composite to be formed.}

\item{r_mat}{Correlation matrix from which the composite is to be computed.}

\item{sd_vec}{Vector of standard deviations associated with variables in the composite to be formed.}

\item{wt_vec}{Weights to be used in forming the composite (by default, all variables receive equal weight).}
}
\value{
The estimated reliability of the composite variable.
}
\description{
This function computes the reliability of a variable that is a weighted or unweighted composite of other variables.
}
\details{
This function treats measure-specific variance as reliable.


The Mosier composite formula is computed as:

\deqn{\rho_{XX}=\frac{\mathbf{w}^{T}\left(\mathbf{r}\circ\mathbf{s}\right)+\mathbf{w}^{T}\mathbf{S}\mathbf{w}-\mathbf{w}^{T}\mathbf{s}}{\mathbf{w}^{T}\mathbf{S}\mathbf{w}}}{rel_composite = (t(wt^2) (rel_vec * var_vec) + S - var_sum) / (t(wt) S wt)}

where \eqn{\rho_{XX}}{rel_composite} is a composite reliability estimate, \eqn{\mathbf{r}}{rel_vec} is a vector of reliability estimates, \eqn{\mathbf{w}}{wt} is a vector of weights, \eqn{\mathbf{S}}{S} is a covariance matrix, and \eqn{\mathbf{s}}{var_vec} is a vector of variances (i.e., the diagonal elements of \eqn{\mathbf{S}}{S}).
}
\examples{
composite_rel_matrix(rel_vec = c(.8, .8),
r_mat = matrix(c(1, .4, .4, 1), 2, 2), sd_vec = c(1, 1))
}
\references{
Mosier, C. I. (1943). On the reliability of a weighted composite.
\emph{Psychometrika, 8}(3), 161–168. \doi{10.1007/BF02288700}

Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings} (3rd ed.).
Thousand Oaks, CA: Sage. \doi{10.4135/9781483398105}. pp. 441 - 447.
}
