% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pt_plot.R
\name{plot}
\alias{plot}
\title{Plot the results of the perturbation table generator}
\usage{
plot(obj, type = "d", file = NULL, ...)
}
\arguments{
\item{obj}{an object of class \code{\linkS4class{ptable}}}

\item{type}{(character) type of graph: distribution "d" (standard),
perturbation panel ("p"), transition matrix "t"}

\item{file}{if not \code{NULL}, a path to a file (with file extension, e.g.
'.pdf' or '.png') where the graph is saved to}

\item{...}{additional parameters passed to methods}
}
\value{
The selected graph is displayed, but there is no direct return
value. The output could also be assigned to an object to receive an object
of class \code{ggplot}.
}
\description{
\code{\link[=plot]{plot()}} makes it easy to visualize the results of the created
ptable-object that has been created by \code{\link[=create_cnt_ptable]{create_cnt_ptable()}},
\code{\link[=create_cnt_ptable]{create_cnt_ptable()}} or \code{\link[=modify_cnt_ptable]{modify_cnt_ptable()}}.
}
\examples{

# Create a ptable for frequency count tables and modify the intervals
ptab <- create_cnt_ptable(D = 3, V = 1.05, js = 1, label = "Example")
ptab_mod <- modify_cnt_ptable(ptab, threshold = 0.3, seed = 5432)

# Distribution Plot of the Noise
plot(ptab_mod, type = "d")

# Perturbations Panel of the Noise
plot(ptab_mod, type = "p")

\donttest{
## Plot and Save the Transition Matrix
plot(ptab_mod, type ="t", 
     file = tempfile("example_tMatrix", fileext = ".pdf"))
}

}
\author{
Tobias Enderle
}
\keyword{plot}
