% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbs_iv.R
\docType{data}
\name{rbs_iv}
\alias{rbs_iv}
\title{Risk Behavior Survey IV drug use information}
\format{
A tibble with 3,560 rows and
10 variables:

\describe{
\item{\strong{who}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Patient ID \cr
}


}
\item{\strong{days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Maximum number of days of IV drug use across all injected drug \cr
}


}
\item{\strong{max}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of drug use events \cr
}


}
\item{\strong{amount}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Indicator of total IV drug exposure for the most used IV drug \cr
}


}
\item{\strong{shared}}{\tabular{ll}{
   \emph{Type:} \tab factor (First/Reference level = No) \cr
    \tab  \cr
   \emph{Description:} \tab Did you share needles in the last 30 days? \cr
    \tab  \cr
   \emph{Levels:} \tab No, Yes \cr
}


}
\item{\strong{cocaine_inject_days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of last 30 when cocaine was injected \cr
}


}
\item{\strong{heroin_inject_days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of last 30 when heroin was injected \cr
}


}
\item{\strong{speedball_inject_days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of last 30 when speedball was injected \cr
}


}
\item{\strong{opioid_inject_days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of last 30 when opioid was injected \cr
}


}
\item{\strong{speed_inject_days}}{\tabular{ll}{
   \emph{Type:} \tab integer \cr
    \tab  \cr
   \emph{Description:} \tab Number of days out of last 30 when speed was injected \cr
}


}
}
}
\usage{
data(rbs_iv)
}
\description{
This is aggregated data in IV drug use. See the
\href{../doc/harmonization.html#rbs}{Harmonization Information} vignette for
more details.
}
\keyword{datasets}
