% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intersection_check.R
\name{intersection_check}
\alias{intersection_check}
\title{Checks a column of PMID's for whether or not they would appear in a
Pubmed search result.}
\usage{
intersection_check(
  df,
  column,
  query,
  api_key,
  batch_size = 1000,
  quiet = FALSE
)
}
\arguments{
\item{df}{A dataframe containing a column of PMID's}

\item{column}{The name of the column containing PMID's}

\item{query}{A character string containing a valid Pubmed search
query}

\item{api_key}{A valid Pubmed API key}

\item{batch_size}{An integer greater than 0 and less than 10000}

\item{quiet}{A boolean TRUE or FALSE. If TRUE, no progress messages
will be printed during download. FALSE by default.}
}
\value{
A data frame containing the original columns, as well as
two additional ones: \code{pm_checked} and \code{found_in_pm_query}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{The new `pm_checked` column is TRUE if Pubmed was successfully
queried and NA if Pubmed was not checked for that PMID (this
may occur in cases where the PMID to be checked is not
well-formed).

The new `found_in_pm_query` column is TRUE if the PMID in
question would appear in a search of Pubmed defined by the
query provided; FALSE if it would not appear in such a search
and NA if the PMID in question was not checked (this may occur
in cases where the PMID is not well-formed).
}\if{html}{\out{</div>}}
}
\description{
Checks a column of PMID's for whether or not they would appear in a
Pubmed search result.
}
\examples{

\dontrun{
## Read in API key
ak <- readLines("api_key.txt")

## Example publications and their corresponding PMID's (some valid
## and some not)
pubs <- tibble::tribble(
  ~pmid,
  "29559429",
  "28837722",
  "28961465",
  "32278621",
  "one hundred of them",
  "28837722",
  "28961465"
)

## Check which ones were authored by Carlisle:
intersection_check(pubs, "pmid", "Carlisle[Author]", ak)

}
}
