% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R2_prec.R
\name{R2_prec}
\alias{R2_prec}
\title{Compute Precision Analyses for R-Squared
This approach simply loops a function from MBESS}
\usage{
R2_prec(R2, nlow, nhigh, pred, ci = 0.95, by = 1)
}
\arguments{
\item{R2}{R-squared}

\item{nlow}{starting sample size}

\item{nhigh}{ending sample size}

\item{pred}{Number of Predictors}

\item{ci}{Type of Confidence Interval (e.g., .95)}

\item{by}{Incremental increase in sample (e.g. nlow = 10, nhigh = 24, by = 2, produces estimates of 10, 12, and 14)}
}
\value{
Precision Analyses for R-Squared
}
\description{
Compute Precision Analyses for R-Squared
This approach simply loops a function from MBESS
}
\examples{
R2_prec(R2=.467, nlow=24, nhigh=100, pred=3, by=4)
}
