% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/itemtable.R
\name{itemtable}
\alias{itemtable}
\title{Summary of DIF items}
\usage{
itemtable(object, all = FALSE, digits = 2)
}
\arguments{
\item{object}{\code{pwrrasch} object}

\item{all}{If \code{TRUE}, all items are included in the table.}

\item{digits}{Integer indicating the number of decimal places.}
}
\description{
This function builds a table of DIF items specified in the \code{pwrrasch} object
}
\examples{
\dontrun{

# item parameters
ipar2 <- ipar1 <- seq(-3, 3, length.out = 20)
# model differential item function (DIF)
ipar2[10] <- ipar1[11]
ipar2[11] <- ipar1[10]
# simulation for b = 100
simres <- pwr.rasch(100, ipar = list(ipar1, ipar2))
itemtable(simres)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Jan Steinfeld \email{jan.steinfeld@univie.ac.at}
}

