% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pqgauss_0.1.8.R
\name{pqgauss}
\alias{pqgauss}
\title{The q-gaussian Distribution}
\usage{
pqgauss(x, q = 0, mu = 0, sig = 1, lower.tail = TRUE)
}
\arguments{
\item{x}{vector of quantiles.}

\item{q}{entropic index.}

\item{mu}{a value for q-mean.}

\item{sig}{a value for q-variance.}

\item{lower.tail}{logical; if TRUE (default), probabilities are P[X <= x] otherwise, P[X > x].}

%\item{p}{vector of probabilities.}

%\item{n}{number of observations. If length(n) > 1, the length is taken to be the number required.}
}
\value{
dqgauss gives the density, pqgauss gives the distribution function, cqgauss gives the quantile function, and rqgauss generates random deviates.
}
\description{
Density, distribution function, quantile function and 
  random generation for the q-gaussian distribution with parameters mu and sig.
}
\details{
If q , mu and sig values are not specified, they assume the default
values of 0, 0 and 1, respectively. 
Defining Z=(q-1)/(3-q), the q-gaussian distribution has density wrinten as

p(x) = (sig*Beta(alpha/2,1/2))^-1*(1+Z(x-mu)^2/sig^2)^-(1+1/Z)/2 

where alpha = 1 - 1/Z when q < 1 and 1/Z when  1 < q < 3.
}
\examples{
 qv <- c(2.8,2.5,2,1.01,0,-5); nn <- 700
 xrg <- sqrt((3-qv[6])/(1-qv[6]))
 xr <- seq(-xrg,xrg,by=2*xrg/nn)
 y0 <- dqgauss(xr,qv[6])
 plot(xr,y0,ty='l',xlim=range(-4.5,4.5),ylab='p(x)',xlab='x')
 for (i in 1:5){
 if (qv[i]< 1) xrg <- sqrt((3-qv[i])/(1-qv[i]))
 else xrg <- 4.5
 vby <- 2*xrg/nn
 xr <- seq(-xrg,xrg,by=2*xrg/nn)
 y0 <- dqgauss(xr,qv[i])
 points (xr,y0,ty='l',col=(i+1))
}
 legend(2, 0.4, legend =c(expression(paste(q==-5)),expression(paste(q==0)),
 expression(paste(q==1.01)),expression(paste(q==2)),expression(paste(q==2.5)),
 expression(paste(q==2.8))),col = c(1,6,5,4,3,2), lty = c(1,1,1,1,1,1))
                          ######
 qv <- 0
 rr <- rqgauss(2^16,qv)
 nn <- 70
 xrg <- sqrt((3-qv)/(1-qv))
 vby <- 2*xrg/(nn)
 xr <- seq(-xrg,xrg,by=vby)
 hist (rr,breaks=xr,freq=FALSE,xlab="x",main='')
 y <- dqgauss(xr)
 lines(xr,y/sum(y*vby),cex=.5,col=2,lty=4)

}
\author{
Emerson Luis de Santa Helena , Wagner Santos de Lima
}
\references{
Thistleton, W.,Marsh, J. A.,Nelson, K.,Tsallis, C., (2007) IEEE Transactions on Information Theory, 53(12):4805

Tsallis, C., (2009) Introduction to Nonextensive Statistical Mechanics. Springer.

de Santa Helena, E. L., Nascimento, C. M., and Gerhardt, G. J., (2015) Alternative way to charecterize a
q-gaussian distribution by a robust heavy tail measurement. Physica A, (435):44-50.

Manuscript submitted for publication (2016) qGaussian: Tools to Explore Applications of Tsallis Statistics
}
\seealso{
Distributions for other standard distributions, including dt and dcauchy.
            \code{\link[stats]{Distributions}}
}

