% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cond_heatmap.R
\name{cond_heatmap}
\alias{cond_heatmap}
\title{Conditional heatmap}
\usage{
cond_heatmap(
  data,
  x = NULL,
  n = 100,
  min_bin_size = NULL,
  overlap = NULL,
  bins = c(n, 25),
  ncols = NULL,
  auto_fill = FALSE,
  show_bins = FALSE,
  fill = "#2f4f4f",
  low = "#eeeeee",
  high = "#2f4f4f",
  ...
)
}
\arguments{
\item{data}{a \code{data.frame} to be binned}

\item{x}{\code{character} variable name used for the quantile binning}

\item{n}{\code{integer} number of quantile bins.}

\item{min_bin_size}{\code{integer} minimum number of rows/data points that should be
in a quantile bin. If NULL it is initially \code{sqrt(nrow(data))}}

\item{overlap}{\code{logical} if \code{TRUE} the quantile bins will overlap. Default value will be
\code{FALSE}.}

\item{bins}{\code{integer} vector with the number of bins to use for the x and y axis.}

\item{ncols}{The number of column to be used in the layout.}

\item{auto_fill}{If \code{TRUE}, use a different color for each category.}

\item{show_bins}{If \code{TRUE}, show the bin boundaries on the x-axis.}

\item{fill}{The color used for categorical variables.}

\item{low}{The color used for low values in the heatmap.}

\item{high}{The color used for high values in the heatmap.}

\item{...}{Additional arguments to pass to the plot functions}
}
\value{
A \code{list} of ggplot objects.
}
\description{
\code{cond_heatmap} shows the conditional distribution of the \code{y}
of variables for each quantile bin of \code{x}. It is an alternative to
\code{\link[=cond_boxplot]{cond_boxplot()}}, fine graining the distribution per \code{\link[=qbin]{qbin()}}.
\code{\link[=cond_barplot]{cond_barplot()}} highlights the median/mean of the quantile bins, while
\code{\link[=funq_plot]{funq_plot()}} highlights the functional dependency of the median.
}
\examples{
cond_heatmap(
  iris,
  x = "Petal.Length",
  n = 12
)

\donttest{

  data("diamonds", package="ggplot2")

  cond_heatmap(
    diamonds,
    x = "carat",
    bins <- c(100,100)
  )[6:8]
}
}
\seealso{
Other conditional quantile plotting functions: 
\code{\link{cond_barplot}()},
\code{\link{cond_boxplot}()},
\code{\link{funq_plot}()}
}
\concept{conditional quantile plotting functions}
