% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qb_records.R
\name{delete_records}
\alias{delete_records}
\title{Delete records}
\usage{
delete_records(subdomain, auth, from, where, agent = NULL)
}
\arguments{
\item{subdomain}{Character vector with one element. Found at the beginning of
the Quickbase URL. Realm specific.}

\item{auth}{Character vector with one element. The Quickbase authentication
scheme you are using to authenticate the request (e.g., user token).}

\item{from}{Character vector. Identifier of the target table.}

\item{where}{Character vector. Condition(s) which target one or more records for
deletion. Use the Quickbase query language to construct your condition(s).}

\item{agent}{Optional. Character vector with one element. Describes
user/agent making API call.}
}
\value{
Named integer vector
}
\description{
Delete one or more records from a table.
}
\examples{
\dontrun{
  delete_records(subdomain = "abc",
             auth = keyring::key_get("qb_example"),
             from = "bn9d8iesz",
             where = "{6.EX.'105'}")
}
}
