% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_repeated_words.R
\name{rm_repeated_words}
\alias{rm_repeated_words}
\alias{ex_repeated_words}
\title{Remove/Replace/Extract Repeating Words}
\usage{
rm_repeated_words(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_repeated_words",
  replacement = "",
  extract = FALSE,
  dictionary = getOption("regex.library"),
  ...
)

ex_repeated_words(
  text.var,
  trim = !extract,
  clean = TRUE,
  pattern = "@rm_repeated_words",
  replacement = "",
  extract = TRUE,
  dictionary = getOption("regex.library"),
  ...
)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white 
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped 
character will be removed.}

\item{pattern}{A character string containing a regular expression (or 
character string for \code{fixed = TRUE}) to be matched in the given 
character vector.  Default, \code{@rm_repeated_words} uses the 
\code{rm_repeated_words} regex from the regular expression dictionary from 
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the repeated words are extracted into a 
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within 
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with percentages removed.
}
\description{
Remove/replace/extract repeating words from a string.
}
\examples{
x <- c(
    "this is a big is a Big deal",
    "I want want to see",
    "I want, want to see",
    "I want...want to see see see how",
    "I like it. It is cool",
    "this is a big is a Big deal for those of, those of you who are."
)

rm_repeated_words(x)
ex_repeated_words(x)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_ functions: 
\code{\link{rm_abbreviation}()},
\code{\link{rm_between}()},
\code{\link{rm_bracket}()},
\code{\link{rm_caps}()},
\code{\link{rm_caps_phrase}()},
\code{\link{rm_citation}()},
\code{\link{rm_citation_tex}()},
\code{\link{rm_city_state}()},
\code{\link{rm_city_state_zip}()},
\code{\link{rm_date}()},
\code{\link{rm_default}()},
\code{\link{rm_dollar}()},
\code{\link{rm_email}()},
\code{\link{rm_emoticon}()},
\code{\link{rm_endmark}()},
\code{\link{rm_hash}()},
\code{\link{rm_nchar_words}()},
\code{\link{rm_non_ascii}()},
\code{\link{rm_non_words}()},
\code{\link{rm_number}()},
\code{\link{rm_percent}()},
\code{\link{rm_phone}()},
\code{\link{rm_postal_code}()},
\code{\link{rm_repeated_characters}()},
\code{\link{rm_repeated_phrases}()},
\code{\link{rm_tag}()},
\code{\link{rm_time}()},
\code{\link{rm_title_name}()},
\code{\link{rm_url}()},
\code{\link{rm_white}()},
\code{\link{rm_zip}()}
}
\concept{rm_ functions}
\keyword{repeat}
\keyword{words}
