% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_beyond_prey.R
\name{pred_beyond_prey}
\alias{pred_beyond_prey}
\title{Identify predator signature proportions beyond range of prey}
\usage{
pred_beyond_prey(pred_sigs, prey_sigs, mean_sigs)
}
\arguments{
\item{pred_sigs}{A numeric matrix of predator signature(s) in
column-major format. Intended to be the object \code{pred_sigs} returned by
the function \code{\link{est_diet}}.}

\item{prey_sigs}{A numeric matrix of prey signatures in column-major format.
Intended to be the object \code{prey_sigs} returned by the function
\code{\link{est_diet}}.}

\item{mean_sigs}{A numeric matrix of mean prey-type signatures. Intended to
be the object \code{prey_sigs} returned by the function
\code{\link{est_diet}}.}
}
\value{
A list containing the following elements: \describe{
  \item{beyond_ind}{A logical matrix with TRUE indicating that the
    corresponding predator proportion is outside the range of individual
    prey proportions.}
  \item{beyond_mean}{A logical matrix with TRUE indicating that the
    corresponding predator proportion is outside the range of mean prey
    proportions.}
  \item{err_code}{An integer error code (0 if no error is detected).}
  \item{err_message}{A string contains a brief summary of the execution.}
  }
}
\description{
The function \code{pred_beyond_prey} identifies predator signaturee
proportions that are outside the range of proportions observed in the
individual and mean prey signatures.
}
\section{Details}{

In quantitative fatty acid signature analysis, predator signatues are assumed
to be a linear mixture of mean prey signatures (Iverson et al. 2004).
Predator signature proportions should therefore be within the range of
the prey signature proportions. Signature proportions outside the range of
prey proportions are indicative of a violation of one or both of the primary
model assumptions, i.e., the prey library is incomplete or the calibration
coefficients are inaccurate (Bromaghin et al. 2015, 2016a). Consequently,
checking for predator proportions that are outside the range of mean prey
proportions is an important diagnostic aid to evaluate the reliability
of diet estimates.

The function \code{pred_beyond_prey} identifies predator signature
proportions that outside the range of proportions observed among the
individual and mean prey signatures. For purposes of diet estimation,
proportions outside the range of the mean signatures are most important.
However, \code{pred_beyond_prey} also identifies predator proportions that
are outside the range of the individual prey proportions for exploratory
purposes.

\code{pred_beyond_prey} is designed to be called with inputs returned by the
function \code{\link{est_diet}}. Although it is not conceptually necessary to
estimate diets before performing this diagnostic check, doing so ensures that
the predator and prey signatures have been transformed to the optimization
space (Bromaghin et al. 2015) in which diets have been estimated.
}

\section{References}{

Iverson, S.J., C. Field, W.D. Bowen, and W. Blanchard. 2004.
  Quantitative fatty acid signature analysis: A new method of
  estimating predator diets. \emph{Ecological Monographs} 74:211-235.

Bromaghin, J.F., S.M. Budge, G.W. Thiemann, and K.D. Rode. 2016. Assessing
  the robustness of quantitative fatty acid signature analysis to assumption
  violations. \emph{Methods in Ecology and Evolution} 7:51-59.

Bromaghin, J.F., K.D. Rode, S.M. Budge, and G.W. Thiemann. 2015. Distance
  measures and optimization spaces in quantitative fatty acid signature
  analysis. \emph{Ecology and Evolution} 5:1249-1262.
}

\examples{
pred_beyond_prey(pred_sigs = matrix(c(0.05, 0.10, 0.30, 0.55,
                                      0.04, 0.11, 0.29, 0.56,
                                      0.10, 0.05, 0.35, 0.50,
                                      0.12, 0.03, 0.37, 0.48,
                                      0.10, 0.06, 0.35, 0.49,
                                      0.05, 0.15, 0.35, 0.45), ncol = 6),
                 prey_sigs = matrix(c(0.06, 0.09, 0.31, 0.54,
                                      0.05, 0.09, 0.30, 0.56,
                                      0.03, 0.10, 0.30, 0.57,
                                      0.08, 0.07, 0.30, 0.55,
                                      0.09, 0.05, 0.33, 0.53,
                                      0.09, 0.06, 0.34, 0.51,
                                      0.09, 0.07, 0.34, 0.50,
                                      0.08, 0.11, 0.35, 0.46,
                                      0.06, 0.14, 0.36, 0.44), ncol = 9),
                 mean_sigs = matrix(c(0.047, 0.093, 0.303, 0.557,
                                      0.087, 0.050, 0.323, 0.530,
                                      0.077, 0.106, 0.350, 0.467), ncol = 3))

}
