% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_qfrm.R
\name{new_qfrm}
\alias{new_qfrm}
\alias{new_qfpm}
\title{Construct qfrm object}
\usage{
new_qfrm(
  statistic,
  error_bound = NULL,
  terms = statistic,
  seq_error = NULL,
  exact = FALSE,
  twosided = FALSE,
  alphaout = FALSE,
  singular_arg = FALSE,
  diminished = FALSE,
  ...,
  class = character()
)

new_qfpm(statistic, exact = TRUE, ..., class = character())
}
\arguments{
\item{statistic}{Terminal value (partial sum) for the moment.  When missing,
obtained as \code{sum(terms)}.}

\item{error_bound}{Terminal error bound.  When missing,
obtained as \code{seq_error[length(seq_error)]}.}

\item{terms}{Terms in series expression for the moment along varying polynomial degrees}

\item{seq_error}{Vector of error bounds corresponding to \code{cumsum(terms)}}

\item{exact, twosided, alphaout, singular_arg}{Logicals used to append attributes to the resultant error bound
(see \dQuote{Value})}

\item{diminished}{Logical used to append attribute to the resultant statistic and terms
(see \dQuote{Value})}

\item{...}{Additional arguments for accommodating subclasses}

\item{class}{Character vector to (pre-)append classes to the return value}
}
\value{
\code{new_qfrm()} and \code{new_qfpm()} return a list of class \code{qfrm}
and \code{c(qfpm, qfrm)}, respectively.  These classes are defined for
the \code{print} and \code{plot} methods.

The return object is a list of 4 elements which are intended to be:
\describe{
\item{\code{$statistic}}{evaluation result (\code{sum(terms)})}
\item{\code{$terms}}{vector of \eqn{0}th to \eqn{m}th order terms}
\item{\code{$error_bound}}{error bound of \code{statistic}}
\item{\code{$seq_error}}{vector of error bounds corresponding to
partial sums (\code{cumsum(terms)})}
}
When the result is exact, \code{$terms} can be of length 1 and equal to
\code{$statistic}.  This is always the case for the \code{qfpm} class.

When the relevant flags are provided in the constructor, \code{$error_bound}
and \code{$seq_error} have the following attributes which control behaviors
of the \code{print} and \code{plot} methods:
\describe{
\item{\code{"exact"}}{indicates whether the moment is exact}
\item{\code{"twosided"}}{indicates whether the error bounds are
two-sided}
\item{\code{"alphaout"}}{indicates whether any of the scaling factors
(\code{alphaA}, \code{alphaB}, \code{alphaD}) is outside
\eqn{(0, 1]}, when error bound does not strictly hold}
\item{\code{"singular"}}{indicates whether the relevant argument matrix
is (numerically) singular, in which case the error bound is
invalid}
}
Similarly, when \code{diminished = TRUE}, \code{$statistic} and \code{$terms}
have the attribute \code{"diminished"} being \code{TRUE}, which indicates
that numerical underflow/diminishing happened during scaling
(see \dQuote{Scaling} in \code{\link{d1_i}}).
}
\description{
These are internal \dQuote{constructor} functions used to make \code{qfrm}
and \code{qfpm} objects, which are used as a return value from the
\code{\link{qfrm}}, \code{\link{qfmrm}}, and \code{\link{qfpm}} functions.
}
\seealso{
\code{\link{qfrm}}, \code{\link{qfmrm}}, \code{\link{qfpm}}: functions
that return objects of these classes

\code{\link{methods.qfrm}}: the \code{print} and \code{plot} methods
}
