% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_utility.R
\name{.qgcomp_object_add}
\alias{.qgcomp_object_add}
\title{Adding objects to a \code{qgcompfit} object}
\usage{
.qgcomp_object_add(x, ..., overwrite_duplicates = TRUE)
}
\arguments{
\item{x}{\code{qgcompfit} object}

\item{...}{named objects to add to the \code{qgcompfit} object}

\item{overwrite_duplicates}{(logical) overwrite list items in \code{qgcompfit} object with arguments that have matching names in \code{...}}
}
\value{
a \code{qgcompfit} object
}
\description{
\code{.qgcomp_object_add} developer function to add items to an existing \code{qgcompfit} object
}
\details{
This is not a generally useful function, except for developers, who need to add items to an existing qgcompfit object.
}
\examples{
set.seed(50)
# linear model, adding an arbitrary string to the object
dat <- data.frame(y=runif(50,-1,1), x1=runif(50), x2=runif(50), z=runif(50))
ft = qgcomp.glm.noboot(f=y ~ z + x1 + x2, expnms = c('x1', 'x2'), data=dat, q=2, family=gaussian())
ft2 = .qgcomp_object_add(ft, date=Sys.Date())
ft2$date # not typically part of a qgcomp object, but could be useful for e.g. datestamping analyses
}
