% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomic_statistics.R
\name{adjStat}
\alias{adjStat}
\title{Adjustment of marker summary statistics using clumping and thresholding}
\usage{
adjStat(
  stat = NULL,
  Glist = NULL,
  chr = NULL,
  statistics = "b",
  r2 = 0.9,
  ldSets = NULL,
  threshold = 1,
  header = NULL,
  method = "pruning"
)
}
\arguments{
\item{stat}{A data frame with marker summary statistics (see required format above).}

\item{Glist}{List of information about genotype matrix stored on disk.}

\item{chr}{Chromosome(s) being processed.}

\item{statistics}{Specify what type of statistics ("b" or "z") is being processed. Default is "b".}

\item{r2}{Threshold used in clumping/pruning procedure. Default is 0.9.}

\item{ldSets}{List of marker sets - names correspond to row names in `stat`.}

\item{threshold}{P-value threshold used in clumping procedure. Default is 1.}

\item{header}{Character vector with column names to be excluded in the LD adjustment.}

\item{method}{Method used in adjustment for linkage disequilibrium. Default is "clumping".}
}
\description{
Adjust marker summary statistics using linkage disequilibrium information from Glist.
}
\details{
Required input format for summary statistics:

stat can be a data.frame(rsids, chr, pos, ea, nea, eaf, b, seb, stat, p, n) (single trait)

stat can be a list(marker=(rsids, chr, pos, ea, nea, eaf), b, seb, stat, p, n) (multiple trait)


For details about the summary statistics format, see the main function description.
}
\author{
Peter Soerensen
}
