% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{qiita_util}
\alias{qiita_util}
\alias{qiita_util_tag}
\alias{qiita_util_payload}
\title{Generate Payload And Tag For Qiita API}
\usage{
qiita_util_tag(name, versions = NULL)

qiita_util_payload(
  body = NULL,
  title = NULL,
  tags = NULL,
  private = NULL,
  coediting = NULL,
  gist = NULL,
  tweet = NULL
)
}
\arguments{
\item{name}{Tag name}

\item{versions}{Versions (e.g. \code{3.1}, \code{>3.2}).}

\item{body}{Content body.}

\item{title}{Title.}

\item{tags}{Tags. Use \code{qiita_util_tag} to generate tag objects.}

\item{private}{If \code{TRUE}, the post will be private.}

\item{coediting}{If \code{TRUE}, the post will be editable by team members.}

\item{gist}{If \code{TRUE}, post the code to Gist.}

\item{tweet}{If \code{TRUE}, notify on Twitter.}
}
\description{
Generate Payload And Tag For Qiita API
}
\examples{
qiita_util_tag(name = "R", versions = ">3.1")

qiita_util_payload(body = "foo",
                   title = "test",
                   tags = list(
                     qiita_util_tag(name = "R", versions = ">3.1"),
                     qiita_util_tag(name = "dplyr")
                   ),
                   private = TRUE)

}
