% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPFISHPower.R
\name{CPFISH.power}
\alias{CPFISH.power}
\title{CPFISH power}
\usage{
CPFISH.power(
  contingency.table,
  control.name = NULL,
  alpha = 0.05,
  bootstrap.runs = 200,
  simulate.p.value = TRUE,
  use.fixed.random.seed = NULL,
  show.progress = TRUE,
  show.results = TRUE
)
}
\arguments{
\item{contingency.table}{Matrix with observed data (e.g. survival counts, survival must be in first row)}

\item{control.name}{Character string with control group name (optional)}

\item{alpha}{Significance level}

\item{bootstrap.runs}{Number of bootstrap runs (draw Poisson data n times)}

\item{simulate.p.value}{Use simulated p-values in Fisher test or not}

\item{use.fixed.random.seed}{Use fixed seed, e.g. 123, for reproducible results. If NULL no seed is set.}

\item{show.progress}{Show progress for each shift of the probability}

\item{show.results}{Show results}
}
\value{
Data frame with results from power analysis
}
\description{
The basic idea of CPFISH power calculations is to do parametric bootstrapping
for each dose/concentration group and to evaluate the proportion of results significantly different from the control.
}
\examples{
CPFISH.contingency.table	# example data provided alongside the package

# Test CPFISH power
CPFISH.power(contingency.table = CPFISH.contingency.table,
			control.name = NULL,
			alpha = 0.05,
			bootstrap.runs = 10,	# Caution: low number of bootstrap runs for testing
			simulate.p.value = TRUE,
			use.fixed.random.seed = 123,  #fixed seed for reproducible results
			show.progress = TRUE,
			show.results = TRUE)
}
