% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqslider.R
\name{qq_plot}
\alias{qq_plot}
\title{Interactive QQ Plot}
\usage{
qq_plot(data, step = 0.05, breaks = "FD")
}
\arguments{
\item{data}{Numerical data vector.}

\item{step}{Stepsize used for Shiny slider (use larger values if animating with play button)}

\item{breaks}{Passed to histogram for empirical distribution (default = "FD")}
}
\value{
None
}
\description{
This function uses Shiny to open the default web browser. Graphical controls
manipulate the construction of an interactive normal QQ plot.
}
\examples{
\dontrun{
qq_plot(rnorm(50))

qq_plot(rnorm(50), step=0.05, breaks="Sturges")

if(require("MASS", quietly=TRUE)){ qq_plot(geyser$waiting) }
}
}

