% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciqtet.R
\name{ci.qtet}
\alias{ci.qtet}
\title{ci.qtet}
\usage{
ci.qtet(
  formla,
  xformla = NULL,
  w = NULL,
  data,
  probs = seq(0.05, 0.95, 0.05),
  se = TRUE,
  iters = 100,
  alp = 0.05,
  method = "logit",
  retEachIter = FALSE,
  indsample = TRUE,
  printIter = FALSE,
  pl = FALSE,
  cores = 2
)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary), d should be equal to one
in all time periods for individuals that are eventually treated}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{w}{an additional vector of sampling weights}

\item{data}{A data.frame containing all the variables used}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{se}{Boolean whether or not to compute standard errors}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{method}{Method to compute propensity score.  Default is logit; other
option is probit.}

\item{retEachIter}{Boolean whether or not to return list of results
from each iteration of the bootstrap procedure (default is FALSE).
This is potentially useful for debugging but can cause errors due
to running out of memory.}

\item{indsample}{Binary variable for whether to treat the samples as
independent or dependent.  This affects bootstrap standard errors.  In
the job training example, the samples are independent because they
are two samples collected independently and then merged.  If the data is
from the same source, usually should set this option to be FALSE.}

\item{printIter}{For debugging only; should leave at default FALSE unless
you want to see a lot of output}

\item{pl}{Whether or not to compute standard errors in parallel}

\item{cores}{Number of cores to use if computing in parallel}
}
\value{
QTE object
}
\description{
The \code{ci.qtet} method implements estimates the Quantile
Treatment Effect on the Treated (QTET) under a Conditional Independence
Assumption (sometimes this is called Selection on Observables) developed
in Firpo (2007).  This method using propensity score re-weighting
and minimizes a check function to compute the QTET.  Standard errors
(if requested) are computed using the bootstrap.
}
\examples{
## Load the data
data(lalonde)

##Estimate the QTET of participating in the job training program;
##This is the no covariate case.  Note: Because individuals that participate
## in the job training program are likely to be much different than
## individuals that do not (e.g. less experience and less education), this
## method is likely to perform poorly at estimating the true QTET
q1 <- ci.qtet(re78 ~ treat, x=NULL, data=lalonde.psid, se=FALSE,
 probs=seq(0.05,0.95,0.05))
summary(q1)

##This estimation controls for all the available background characteristics.
q2 <- ci.qtet(re78 ~ treat, 
 xformla=~age + I(age^2) + education + black + hispanic + married + nodegree,
 data=lalonde.psid, se=FALSE, probs=seq(0.05, 0.95, 0.05))
summary(q2)

}
\references{
Firpo, Sergio.   ``Efficient Semiparametric Estimation of Quantile Treatment
Effects.'' Econometrica 75.1, pp. 259-276, 2015.
}
