% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createTLC.R
\name{createTLC}
\alias{createTLC}
\title{Creates TLC S3 object}
\usage{
createTLC(ttiff, turnv = TRUE, ...)
}
\arguments{
\item{ttiff}{File name of the TIFF image with scanned TLC plate.}

\item{turnv}{Boolean value determines to turn vertically data in the matrix. TRUE generates turned image which is useful for Cartesian coordinates, because without turning the coordinate system begins in the left corner of the monithor and rises left and down.}

\item{...}{Additional parameters for TIFF image manipulation.}
}
\value{
An object of class \code{qtlc}, that contains TLC matrix and descriptions. The object contains: \item{file_name}{File name of of the TIFF image from which the TLC matrix was created.} \item{mat}{TLC matrix (or matrices if intensities Red, Green and Blue channels are not combined.)} \item{spots}{Coordinates of marked spots (using function \code{spot2D}).}
}
\description{
Create matrix from TLC image
}
\examples{
#Creates test matrix.
# RGB channels stay separated, or
# intensities are combined.
fname01 <- system.file("extdata", "testTIFF.tiff", package="qtlc")
testTLC <- createTLC(fname01, RGB=TRUE)
print(testTLC)

}
\author{
Ivan D. Pavicevic, \email{ivanp84@gmail.com}
}
\keyword{array}
\keyword{device}

